<?php
require("include/conn.php");
ob_start();
session_start();
if(isset($_SESSION["s_username"],$_SESSION["s_pass"])){ 
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <title>RoidBett - Betting Panel</title>
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    <link href="css/sb-admin-2.css" rel="stylesheet">
    <link rel="stylesheet" href="css/toastr.min.css"crossorigin="anonymous">
    <link rel="stylesheet" href="vendor/jquery/jquery-ui.min.css"crossorigin="anonymous">
</head>

<body id="page-top">
    <!-- Page Wrapper -->
    <div id="wrapper">
        <!-- Sidebar -->
        <ul class="navbar-nav bg-gradient-danger sidebar sidebar-dark accordion" id="accordionSidebar">
            <!-- Sidebar - Brand -->
            <div class="text-center" style="margin:15px">
                <img src="img/logo.png" style="max-width:80px"/>
            </div>

             <div class="sidebar-heading">
                Prediction
            </div>

            <li class="nav-item active">
                <a class="nav-link" href="betting.php">
                    <i class="fas fa-futbol"></i>
                    <span>Prediction</span>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="addbetting.php">
                    <i class="fas fa-plus-circle"></i>
                    <span>Add Prediction</span>
                </a>
            </li>
 <div class="sidebar-heading">
                NEWS
            </div>

            <li class="nav-item" active>
                <a class="nav-link" href="news.php">
                    <i class="fas fa-futbol"></i>
                    <span>News</span>
                </a>
            </li>

            <li class="nav-item">
                <a class="nav-link" href="addnews.php">
                    <i class="fas fa-plus-circle"></i>
                    <span>Add News</span>
                </a>
            </li>

            <hr class="sidebar-divider">
     <li class="nav-item">
                <a class="nav-link" href="setting.php">
                    <i class="fas fa-cog"></i>
                    <span>Social Setting</span>
                </a>
            </li>
						
            <hr class="sidebar-divider">
            <div class="sidebar-heading">
                Users
            </div>

            <li class="nav-item">
                <a class="nav-link" href="users.php">
                    <i class="fas fa-user"></i>
                    <span>User List</span>
                </a>
            </li>

          

      

        </ul>
        <!-- End of Sidebar -->

        <!-- Content Wrapper -->
        <div id="content-wrapper" class="d-flex flex-column">

            <!-- Main Content -->
            <div id="content">

                <!-- Topbar -->
                <nav class="navbar navbar-expand navbar-light bg-white topbar mb-4 static-top shadow">

                    <!-- Sidebar Toggle (Topbar) -->
                    <button id="sidebarToggleTop" class="btn btn-link d-md-none rounded-circle mr-3">
                        <i class="fa fa-bars"></i>
                    </button>

                    <!-- Topbar Navbar -->
                    <ul class="navbar-nav ml-auto">
    
                        <li class="nav-item dropdown no-arrow">
                            <a class="nav-link dropdown-toggle" href="#" id="userDropdown" role="button"
                                data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <span class="mr-2 d-none d-lg-inline text-gray-600 small"><?php echo($_SESSION["s_username"]); ?></span>
                                <img class="img-profile rounded-circle"
                                    src="img/undraw_profile.svg">
                            </a>
    
                            <div class="dropdown-menu dropdown-menu-right shadow animated--grow-in"
                                aria-labelledby="userDropdown">
                                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#usettingsModal">
                                    <i class="fas fa-user fa-sm fa-fw mr-2 text-gray-400"></i>
                                    User Setting
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="#" data-toggle="modal" data-target="#logoutModal">
                                    <i class="fas fa-sign-out-alt fa-sm fa-fw mr-2 text-gray-400"></i>
                                    Log Out
                                </a>
                            </div>
                        </li>
                    </ul>
                </nav>
                <!-- End of Topbar -->

                <!-- Begin Page Content -->
                <div class="container-fluid">
                    <h1 class="h3 mb-4 text-gray-800">Users </h1>
                    <div class="card shadow mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">Users</h6>
                        </div>
                        <div class="card-body">
                            <div class="text-right" style="margin-bottom:10px">
                                <button type="button" href="#" data-toggle="modal" data-target="#searchModal" class="btn btn-secondary">Users Search  <i class="fas fa-search"></i></button>
                            </div>
                            
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dataTable" width="100%" cellspacing="0">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Surname-Name</th>
                                            <th>Credit</th>
                                            <th>VIP</th>
                                            <th>Setting</th>
                                        </tr>
                                    </thead>
                                    <tbody id="table-body">
                                                       (User List)                  
                                    </tbody>
                                </table>
                            </div>
                                <nav class="m-auto" aria-label="page">
                                  <ul class="pagination" id="pagination">
                                     
                                  </ul>
                                </nav>
                        </div>
                    </div>
                </div>

            </div>
            <footer class="sticky-footer bg-white">
                <div class="container my-auto">
                    <div class="copyright text-center my-auto">
                        <span>Copyright &copy; Betting v1.0 2022</span>
                    </div>
                </div>
            </footer>

        </div>


    </div>

    <a class="scroll-to-top rounded" href="#page-top">
        <i class="fas fa-angle-up"></i>
    </a>

    <div class="modal fade" id="logoutModal" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Log Out</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">Are you sure you want to log out?</div>
                <div class="modal-footer">
                    <button class="btn btn-secondary" type="button" data-dismiss="modal">Cancel</button>
                    <a class="btn btn-primary" href="logout.php">Okke</a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="modal fade" id="searchModal" role="dialog" aria-labelledby="searchLabel"
        aria-hidden="true">
        <div class="modal-dialog" style="max-width:900px" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="searchLabel">Users Search</h5>
                    <button class="close" type="button" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table style="width:100%">
                        <tr>
                            <td><input class="form-control" placeholder="E-mail" id="searchEmail"/></td>
                            <td><button class="btn btn-primary" style="width:100%" type="button" id="searchBtn">Search</button></td>
                        </tr>
                    </table>
                    <br/>
                    <div id="searchResults"></div>
                    <br/>
                    <div class="text-right">
                        <button class="btn btn-secondary" type="button" data-dismiss="modal">Close</button>
                    </div>
                </div>
                
            </div>
        </div>
    </div>


   <?php include("include/userSettingsModal.php"); ?>

    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/jquery/jquery-ui.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sweetalert2.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
    <script src="js/toastr.min.js" crossorigin="anonymous"></script>
    <script src="js/modalSaveUser.js"></script>
    <script type="text/javascript">
    var currentPage = 1;

    jQuery(document).ready(function() {
        getUserPage(1);
        setPagination();
    });

    function getUserPage(page){
         currentPage = page;

         jQuery.ajax({
             type: 'GET',
             url: 'https://adminapi.domain.com/getUsers/53a84010ac9013053ac86fa/' + page,
             data: {}, 
             dataType: 'json',
             beforeSend: function() {
                $( "#table-body" ).html('<div class="table-loading-overlay"><div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div></div>');
             },
             success: function(data) {
                 $( "#table-body" ).html("");
                 $.each(data, function(index, item) {
                    var d = new Date();
                    var todayDate = d.getTime();
                    var dbOvunDate = new Date(item["ovun"] * 1000);
                    var dbHtftDate = new Date(item["htft"] * 1000);
                    var dbTwohDate = new Date(item["twoh"] * 1000);
                    var dbPlatDate = new Date(item["plat"] * 1000);

                    var ovunData = "";
                    var htftData = "";
                    var twohData = "";
                    var platData = "";

                    if(dbOvunDate > todayDate){
                        ovunData = "active";
                    }

                    if(dbHtftDate > todayDate){
                        htftData = "active";
                    }

                    if(dbTwohDate > todayDate){
                        twohData = "active";
                    }

                    if(dbPlatDate > todayDate){
                        platData = "active";
                    }

                    var userCreditBtn = "javascript:setUserCredit('" + index + "'," + item["credit"] + ")";
                    var ovunEditBtn = "javascript:setUserVip('" + index + "', 1, '" + item["ovun"] + "')";
                    var htftEditBtn = "javascript:setUserVip('" + index + "', 2, '" + item["htft"] + "')";
                    var twohEditBtn = "javascript:setUserVip('" + index + "', 3, '" + item["twoh"] + "')";
                    var platEditBtn = "javascript:setUserVip('" + index + "', 4, '" + item["plat"] + "')";


                    $( "#table-body" ).append( '<tr> <td>' + item["id"] + '</td> <td>' + item["name"] + ' ' + item["surname"] + '</td> <td>' + item["email"] + '</td><td class="text-center"><b>' + item["credit"] + '</b></td> <td class="text-center"> <div class="vip"> <a href="' + ovunEditBtn + '"><span class="' + ovunData + '">OV / UN</span></a> <a href="' + htftEditBtn + '"><span class="' + htftData + '">HT / FT</span></a> <a href="' + twohEditBtn + '"><span class="' + twohData + '">+200</span></a> <a href="'+ platEditBtn +'"><span class="' + platData + '">PLAT</span> </a></div> </td> <td class="text-center"> <a href="' + userCreditBtn + '" class="btn btn-warning btn-circle btn-sm"> <i class="fas fa-coins"></i> </a> </td> </tr>' );
                 });

             },
             error: function(XMLHttpRequest, textStatus, errorThrown) {
                 console.log("some error");
             }
         });
    }
    
    $('#searchBtn').click(function(event) {
        var searchMail = $("#searchEmail").val();
        
        if(searchMail != ""){
         jQuery.ajax({
             type: 'GET',
             url: 'https://adminapi.domain.com/searchUser/53a84010ac9013053ac86fa/' + searchMail,
             data: {}, 
             dataType: 'json',
             beforeSend: function() {
                $( "#searchResults" ).html('<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>');
             },
             success: function(data) {
                   console.log(data);
                   $( "#searchResults" ).html("");
                   
                   if(data["ovun"] != undefined){
                    var d = new Date();
                    var todayDate = d.getTime();
                    var dbOvunDate = new Date(data["ovun"] * 1000);
                    var dbHtftDate = new Date(data["htft"] * 1000);
                    var dbTwohDate = new Date(data["twoh"] * 1000);
                    var dbPlatDate = new Date(data["plat"] * 1000);

                    var ovunData = "";
                    var htftData = "";
                    var twohData = "";
                    var platData = "";

                    if(dbOvunDate > todayDate){
                        ovunData = "active";
                    }

                    if(dbHtftDate > todayDate){
                        htftData = "active";
                    }

                    if(dbTwohDate > todayDate){
                        twohData = "active";
                    }

                    if(dbPlatDate > todayDate){
                        platData = "active";
                    }

                    var userCreditBtn = "javascript:setUserCredit('" + data["uid"] + "'," + data["credit"] + ")";
                    var ovunEditBtn = "javascript:setUserVip('" + data["uid"] + "', 1, '" + data["ovun"] + "')";
                    var htftEditBtn = "javascript:setUserVip('" + data["uid"] + "', 2, '" + data["htft"] + "')";
                    var twohEditBtn = "javascript:setUserVip('" + data["uid"] + "', 3, '" + data["twoh"] + "')";
                    var platEditBtn = "javascript:setUserVip('" + data["uid"] + "', 4, '" + data["plat"] + "')";


                    $( "#searchResults" ).html( '<table class="table table-bordered"  width="100%" cellspacing="0"> <thead> <tr> <th>ID</th> <th>İsim - Soyisim</th> <th>Kredi</th> <th>VIP</th> <th>İşlemler</th> </tr> </thead><tr> <td>' + data["id"] + '</td> <td>' + data["name"] + ' ' + data["surname"] + '</td> <td class="text-center"><b>' + data["credit"] + '</b></td> <td class="text-center"> <div class="vip"> <a href="' + ovunEditBtn + '"><span class="' + ovunData + '">OV / UN</span></a> <a href="' + htftEditBtn + '"><span class="' + htftData + '">HT / FT</span></a> <a href="' + twohEditBtn + '"><span class="' + twohData + '">+200</span></a> <a href="'+ platEditBtn +'"><span class="' + platData + '">PLAT</span> </a></div> </td> <td class="text-center"> <a href="' + userCreditBtn + '" class="btn btn-warning btn-circle btn-sm"> <i class="fas fa-coins"></i> </a> </td> </tr></table>' );

                   }else{
                       $( "#searchResults" ).html("Not Found Users");
                   }
                 


             },
             error: function(XMLHttpRequest, textStatus, errorThrown) {
                 console.log("some error");
             }
         });
        }
        
    });

    function setPagination(){
         jQuery.ajax({
             type: 'GET',
             url: 'https://api.domain.com/admin/getUserCount/53a84010ac9013053ac86fa',
             data: {}, 
             dataType: 'json',
             beforeSend: function() {
                $( "#pagination" ).html('<div class="spinner-border" role="status"><span class="sr-only">Loading...</span></div>');
             },
             success: function(data) {
                $( "#pagination" ).html('');
                var userConut = data["count"];
                var userPerPage = 10;
                var pageCount = Math.ceil(userConut/userPerPage);
            
                for(i = 1; i<=pageCount; i++){
                    $( "#pagination" ).append('<li class="page-item"><a class="page-link" href="javascript:getUserPage(' + i + ');">' + i + '</a></li>');
                }
             },
             error: function(XMLHttpRequest, textStatus, errorThrown) {
                 console.log("some error");
             }
         });
    }

         function setUserCredit(uid, oldCredit){
            Swal.fire({
              title: 'Change User Credit',
              input: 'number',
              inputLabel: 'amount of diamonds',
              inputValue: oldCredit,
              showCancelButton: true,
              confirmButtonText: 'Save',
              cancelButtonText: 'Cancel',
              showLoaderOnConfirm: true,
              preConfirm: (value) => {
                jQuery.ajax({
                    type: 'GET',
                    url: 'https://adminapi.domain.com/setUserCredit/53a84010ac9013053ac86fa/' + uid + '/' + value,
                    data: {}
                });
              },
              allowOutsideClick: () => !Swal.isLoading()
           }).then((result) => {
              if (result.isConfirmed) {
                  let timerInterval
                  Swal.fire({
                      title: 'Updated!',
                      html: 'Registrations will be renewed in 1 second',
                      icon: 'success',
                      timer: 1000,
                      timerProgressBar: true,
                      showCancelButton: false,
                      didOpen: () => {
                          Swal.showLoading()
                      },
                      willClose: () => {
                          clearInterval(timerInterval)
                      }
                  }).then((result) => {
                      getUserPage(currentPage);
                  })
              }
          });
         }

         function setUserVip(uid, vipid, oldTime){
            Swal.fire({
              title: 'User VIP Packet Setting',
              html: '<span id="old_date"></span><div class="row"><div class="col-md-4"><input type="number" class="form-control" placeholder="Day" id="dateDay" autocomplete="off"></div><div class="col-md-4"><input type="number" class="form-control" placeholder="Mont." id="dateMonth" autocomplete="off"></div><div class="col-md-4"><input type="number" class="form-control" placeholder="Year" id="dateYear" autocomplete="off"></div></div> ',
              showCancelButton: true,
              confirmButtonText: 'Save',
              cancelButtonText: 'Cancel',
              showLoaderOnConfirm: true,
              didOpen: () => {
                   if(oldTime > 1000){
                     var oldDate = new Date(oldTime * 1000);
                     var dt=eval(oldTime*1000);
                     var oldDate = new Date(dt);
                     $("#old_date").html("Recorded end date : " + oldDate.toLocaleString());
                   }   
              },
              preConfirm: () => {
                var newDate = new Date($("#dateMonth").val() + "/" + $("#dateDay").val() + "/" + $("#dateYear").val())

                var newTime = newDate.getTime() / 1000

                var vipname = "";
                if(vipid == 1){
                    vipname = "ovun";
                }else if(vipid == 2){
                    vipname = "htft";
                }else if(vipid == 3){
                    vipname = "twoh";
                }else if(vipid == 4){
                    vipname = "plat";
                }

                if(vipname != ""){
                  jQuery.ajax({
                    type: 'GET',
                    url: 'https://adminapi.domain.com/setUserVip/53a84010ac9013053ac86fa/' + uid + '/' + vipname + '/' + newTime,
                    data: {}
                  });
                }

              },
              allowOutsideClick: () => !Swal.isLoading()
           }).then((result) => {
              if (result.isConfirmed) {
                  let timerInterval
                  Swal.fire({
                      title: 'Updated!',
                      html: 'Registrations will be renewed in 1 second.',
                      icon: 'success',
                      timer: 1000,
                      timerProgressBar: true,
                      showCancelButton: false,
                      didOpen: () => {
                          Swal.showLoading()
                      },
                      willClose: () => {
                          clearInterval(timerInterval)
                      }
                  }).then((result) => {
                      getUserPage(currentPage);
                  })
              }
          });
         }
    </script>
</body>

</html>

<?php }else{header("Location: login.php");} ?>